library smtlib;

{$mode objfpc}{$H+}

uses
  Classes, SysUtils, DateUtils, crc, DCPdes, DCPsha1
  //, uSMBIOS, ethernet_address
  { you can add units after this };

procedure crcMyFile(FileName: String; var Result: Cardinal);
var Len: Integer;
  buff: array[0..127] of byte;
begin
  Result := crc32(0, nil, 0); //Grund Hash von leeren Bytes erstellen
  With TFileStream.Create(FileName, fmOpenRead) do  //Datei öffnen
  begin
    try
      repeat
        Len := Read(buff, 128);  // 128 Byte aus datei Lesen
        Result := crc32(Result, @buff, len); // Hash Updaten
      until len<128; // Solange lesen bis EOF
    finally
      Free;
    end;
  end;
end;

procedure generate_total(var report: TStringList; var amt: integer);

function hextodecstr( v : string):string;
var vs : string;
    ts : string;
begin
  ts := '';
  while length(v)>0 do
  begin
    vs := copy( v, 1, 2);
    ts := vs + ts;
    v  := copy( v, 3, length(v));
  end;
  result := IntTostr(StrToInt('$'+ts));
end;

var
  i:integer;
  d, b: string;
  AmtStr: string;
  LastAmtStr: string;
  Data: string;
  ListModif: TStringList;

begin
ListModif := TStringList.Create;

if report.Count > 0 then
for i:=0 to pred(report.Count) do
begin
     Data:=report[i];
     AmtStr := copy(Data, 47, 8);
     b := hextodecstr(AmtStr);
     amt := amt + StrToInt(b);
  while length(b) < 8 do
    b := '0' + b;

  LastAmtStr:= copy(Data, 55, 8);;
   d := hextodecstr(LastAmtStr);
  while length(d) < 8 do
    d := '0' + d;

  Data := stringReplace(Data , AmtStr, b,[rfReplaceAll, rfIgnoreCase]);
  Data := stringReplace(Data , LastAmtStr, d,[rfReplaceAll, rfIgnoreCase]);
  ListModif.add(Data);
end;

report:= ListModif;

end;

procedure generate_total_bri(report: TStringList; var amt: integer);
var
  i:integer;
  AmtStr: string;
  Data: string;

begin
if report.Count > 0 then
for i:=0 to pred(report.Count) do
begin
     Data:=report[i];
     AmtStr := copy(Data, 29, 8);
     amt := amt + StrToInt(AmtStr);
  end;
end;

procedure generate_total_bca(report: TStringList; var amt: integer);
var
  i:integer;
  AmtStr: string;
  Data: string;

begin
if report.Count > 0 then
for i:=0 to pred(report.Count) do
begin
     Data:=report[i];
     AmtStr := copy(Data, 47, 10);
     amt := amt + StrToInt(AmtStr);
  end;
end;

{function read_file(FName: string):boolean;
var
  Txt: TextFile;
  s: string;
  AllText: string;
  DCP_3des   : TDCP_3des;
  SHA_PHRASE: string;
  DataKey: string;

  SMBios             : TSMBios;
  LProcessorInfo     : TProcessorInformation;
  LBaseBoard : TBaseBoardInformation;
  DataPC: string;
  Mac: string;
begin
  SHA_PHRASE := '0D706E8000041312000000404B4C00061114916F796BFFA2DD47B3CC';
  DCP_3des := TDCP_3des.Create(nil);
  DCP_3des.InitStr(SHA_PHRASE, TDCP_Sha1);
  //DCP_3des.Reset;

  SMBios:=TSMBios.Create;
  try

      if SMBios.HasProcessorInfo then
      for LProcessorInfo in SMBios.ProcessorInfo do
      begin
       DataPC := Format('%x',[LProcessorInfo.RAWProcessorInformation^.ProcessorID]);
      end ;

      Mac := TUtil.GetMacAddress();
       DataPC := DataPC + Mac;

      if SMBios.HasBaseBoardInfo then
      for LBaseBoard in SMBios.BaseBoardInfo do
      begin
       DataPC := DataPC + LBaseBoard.SerialNumberStr;
      end ;

  finally
   SMBios.Free;
  end;

  FName := GetCurrentDir + FName;
  if FileExists(FName) then
  begin
    AssignFile(Txt,FName);
    Reset(Txt);
    try
      while not eof(Txt) do
      begin
        ReadLn(Txt, S);
        AllText := AllText + s;
        DataKey := DCP_3des.DecryptString(AllText);

      end;  // while

      if DataKey = DataPC then
       begin
         result := true;
       end
       else
       begin
          result := false;
       end

    finally
      CloseFile(Txt);
    end;

  end
  else
  begin
    result := false;
  end;

end;}

function Generate_Settlement_BNI(merchantid, terminalid, datesettle, timesettle : string; report: TStringList):Integer;stdcall;
var i: integer;
    filename: string;
    header: string;
    footer: string;
    StrOK: TStringList;
    st: string;
    ResCRC: string;
    tfOut: TextFile;
    varCRC: Cardinal;
    res: integer;
    resultkey: boolean;
    //report: TStringList;
    ThisMoment : TDateTime;

begin

  res := 0;
  //if read_file('\Reg.signature') then
  //begin

  StrOK := TStringList.Create;
  ThisMoment:=Now;

  //report := TStringList.Create;
  //report.Delimiter := '|';
  //report.DelimitedText := reports;

try

If Not DirectoryExists('SettlementBNI\' + FormatDateTime('DDMMYYYY',ThisMoment)) then
   ForceDirectories('SettlementBNI\' + FormatDateTime('DDMMYYYY',ThisMoment));

 filename := merchantid + terminalid + datesettle + timesettle ;
 StrOK.SaveToFile('SettlementBNI\' + FormatDateTime('DDMMYYYY',ThisMoment) + '\' + filename + '.ok');

 AssignFile(tfOut, 'SettlementBNI\' + FormatDateTime('DDMMYYYY',ThisMoment) + '\' + filename + '.txt');

  try
  rewrite(tfOut);

  header:='H01' + merchantid + terminalid;
  write(tfOut, header + #10);

  if report.Count > 0 then
    for i:=0 to pred(report.Count) do
   begin
   st:='';
   //st:= 'D' + report[i];
   st:= report[i];
    while length(st) < 218 do
    st:= st + ' ';

      write(tfOut, st + #10);
   end;

   st:='';
   st := IntToStr(report.Count);
   while length(st) < 6 do
   st :=  '0' + st;

    footer:='T' + st + '00000000';
    write(tfOut, footer);

    CloseFile(tfOut);

    res := 0;
  except
    res := 1;
  end;

  crcMyFile('SettlementBNI\' + FormatDateTime('DDMMYYYY',ThisMoment) + '\' + filename + '.txt', varCRC);
  ResCRC:= IntToHex(varCRC, 8);

  AssignFile(tfOut, 'SettlementBNI\' + FormatDateTime('DDMMYYYY',ThisMoment) + '\' + filename + '.txt');
  try
  rewrite(tfOut);

  header:='H01' + merchantid + terminalid;
  write(tfOut, header + #10);

  if report.Count > 0 then
    for i:=0 to pred(report.Count) do
   begin
   st:='';
   //st:= 'D' + report[i];
   st:= report[i];
    while length(st) < 218 do
    st:= st + ' ';

      write(tfOut, st + #10);
   end;

   st:='';
   st := IntToStr(report.Count);
   while length(st) < 6 do
   st :=  '0' + st;

    footer:='T' + st + LowerCase(ResCRC);
    write(tfOut, footer);

    CloseFile(tfOut);

    res := 0;
  except
    res := 1;
  end;

finally
  StrOK.Free;

end;
//
//  end
//  else
//  begin
//     res := 3;
//  end;

result := res;

end;

function Generate_Settlement_MANDIRI(instid, shiftid, terminalid, datetimetrx, datetimesettle : string; report: TStringList):Integer;stdcall;
var i: integer;
    filename: string;
    header: string;
    footer: string;
    st: string;
    StrOK: TStringList;
    tfOut: TextFile;
    datasignature: string;
    countstr: string;
    totalstr: string;
    total: integer;
    res: integer;
    //report: TStringList;
    ThisMoment : TDateTime;

begin

res := 0;
//if read_file('\Reg.signature') then
//begin

  StrOK := TStringList.Create;
  ThisMoment:=Now;

  //report := TStringList.Create;
  //report.Delimiter := '|';
  //report.DelimitedText := reports;

try

If Not DirectoryExists('SettlementMANDIRI\' + FormatDateTime('DDMMYYYY',ThisMoment)) then
   ForceDirectories('SettlementMANDIRI\' + FormatDateTime('DDMMYYYY',ThisMoment));

 datasignature:= copy(datetimesettle, 2, 1) + copy(datetimesettle, 10, 1) + copy(datetimesettle, 12, 1) + copy(terminalid, 8, 1);

 filename := instid + shiftid + terminalid + '01' + datetimetrx + datetimesettle + datasignature;
 StrOK.SaveToFile('SettlementMANDIRI\' + FormatDateTime('DDMMYYYY',ThisMoment) + '\' + filename + '.ok');

 AssignFile(tfOut,'SettlementMANDIRI\' + FormatDateTime('DDMMYYYY',ThisMoment) + '\' + filename + '.txt');

  try
  rewrite(tfOut);

  total:=0;
  generate_total(report, total);

  countstr:= IntToStr(report.Count + 2);
  while length(countstr) < 8 do
   countstr :=  '0' + countstr;

  totalstr:=IntToStr(total);
   while length(totalstr) < 12 do
   totalstr :=  '0' + totalstr;

  header:='PREPAID' + countstr + totalstr + shiftid + instid + FormatDateTime('DDMMYYYY',ThisMoment);
  write(tfOut, header + chr(3) + #10);

  if report.Count > 0 then
  for i:=0 to pred(report.Count) do
   begin
   countstr:=IntToStr(i+1);
   while length(countstr) < 6 do
   countstr :=  '0' + countstr;

   st:='';
   st:= (report[i]) + shiftid + countstr;
      write(tfOut, st + chr(3) + #10);
   end;

   st:='';
   st := IntToStr(report.Count);
   while length(st) < 8 do
   st :=  '0' + st;

    footer:= instid + st + chr(3) + #10;
    write(tfOut, footer);

    CloseFile(tfOut);

    res := 0;
  except
    res := 1;
  end;

finally
  StrOK.Free;
end;

//end
//  else
//  begin
//     res := 3;
//  end;
//
result := res;

end;

function Generate_Settlement_BRI(proccode, merchantid, datetimesettle, batchsettle : string; report: TStringList):Integer;stdcall;
var i: integer;
    filename: string;
    header: string;
    st: string;
    tfOut: TextFile;
    countstr: string;
    totalstr: string;
    total: integer;
    res: integer;
    //report: TStringList;
    ThisMoment : TDateTime;

begin

res := 0;
//if read_file('\Reg.signature') then
//begin

  ThisMoment:=Now;

  //report := TStringList.Create;
  //report.Delimiter := '|';
  //report.DelimitedText := reports;

try

If Not DirectoryExists('SettlementBRI\' + FormatDateTime('DDMMYYYY',ThisMoment)) then
   ForceDirectories('SettlementBRI\' + FormatDateTime('DDMMYYYY',ThisMoment));

 filename := proccode + '_' + merchantid + '_' + datetimesettle + '_' + batchsettle;

 AssignFile(tfOut,'SettlementBRI\' + FormatDateTime('DDMMYYYY',ThisMoment) + '\' + filename + '.bri');

  try
  rewrite(tfOut);

  total:=0;
  generate_total_bri(report, total);

  countstr:= IntToStr(report.Count);
  while length(countstr) < 8 do
   countstr :=  '0' + countstr;

  totalstr:=IntToStr(total);
   while length(totalstr) < 10 do
   totalstr :=  '0' + totalstr;

  header:= countstr + totalstr + '00';
  write(tfOut, header + #10);

  if report.Count > 0 then
  for i:=0 to pred(report.Count) do
   begin
   st:='';
   st:= (report[i]);
      write(tfOut, st + #10);
   end;

    CloseFile(tfOut);

    res := 0;
  except
    res := 1;
  end;

finally

end;

//end
//  else
//  begin
//     res := 3;
//  end;

result := res;

end;

function Generate_Settlement_BCA(datesettle, terminalid, batchno, timesettle : string; report: TStringList):Integer;stdcall;
var i: integer;
    filename: string;
    header: string;
    footer: string;
    st: string;
    tfOut: TextFile;
    countstr: string;
    totalstr: string;
    total: integer;
    MerchantID, Detail: string;
    RecordType, CardNo, ExpiryDate, Amount, SystemTraceNo, TransactionTime, TransactionDate, POSEntryMode, NII,
    POSConditionCode, TID, MID, InvoiceNo, UpdateStatus, ProductID, PurseExpiryDate, PursePAN, PurseBalance, PurseID,
    RTERM, CTC, CCARD30, CTERM, TTC, CDC76, TRN, YEAR, PSAMID, FlazzVersion, FlazzOtherData : string;
    FRecordType, FTID, FMID, FBatchNo, FSalesCount, Amt, FSalesAmount, FSettlementTime, FSettlementDate, FSettlementYear,
    e, FReserved : string;
    res: integer;
    //report: TStringList;
    ThisMoment : TDateTime;

begin

res := 0;
//if read_file('\Reg.signature') then
//begin

  ThisMoment:=Now;

  //report := TStringList.Create;
  //report.Delimiter := '|';
  //report.DelimitedText := reports;

try

If Not DirectoryExists('SettlementBCA\' + FormatDateTime('DDMMYYYY',ThisMoment)) then
   ForceDirectories('SettlementBCA\' + FormatDateTime('DDMMYYYY',ThisMoment));

 filename := datesettle + terminalid + batchno + timesettle;

 AssignFile(tfOut,'SettlementBCA\' + FormatDateTime('DDMMYYYY',ThisMoment) + '\' + filename + '.txn');

  try
  rewrite(tfOut);

  total:=0;
  generate_total_bca(report, total);

  countstr:= IntToStr(report.Count);
  while length(countstr) < 6 do
   countstr :=  '0' + countstr;

  totalstr:=IntToStr(total);
   while length(totalstr) < 10 do
   totalstr :=  '0' + totalstr;

  header:='BULKFILE02';

  if report.Count > 0 then
  for i:=0 to pred(report.Count) do
   begin

   st:='';
   st:= (report[i]);
   RecordType:= '0220';
   CardNo:= LeftStr(st, 16);
   ExpiryDate:= copy(st, 162, 4);
   Amount:= copy(st, 47, 10) + '00';
   SystemTraceNo:= countstr;
   TransactionTime:= copy(st, 31, 6);
   TransactionDate:= copy(st, 27, 4);
   POSEntryMode:= '021';
   NII:= '006';
   POSConditionCode:= '00';
   TID:= copy(st, 136, 8);

   MerchantID:= copy(st, 124, 12);
   while length(MerchantID) < 15 do
   MerchantID :=  '0' + MerchantID;

   MID:= MerchantID;
   InvoiceNo:= countstr;
   UpdateStatus:= copy(st, 57, 1);
   ProductID:= copy(CardNo, 7, 2);
   PurseExpiryDate:= copy(st, 17, 6);
   PursePAN:= CardNo;
   PurseBalance:= copy(st, 37, 10) + '00';
   PurseID:= copy(CardNo, 7, 10);
   RTERM:= copy(st, 74, 16);
   CTC:= copy(st, 114, 6);
   CCARD30:= copy(st, 106, 8);
   CTERM:= copy(st, 90, 16);
   TTC:= copy(st, 66, 8);
   CDC76:= copy(st, 120, 4);
   TRN:= copy(st, 144, 16);
   YEAR:= copy(st, 23, 4);
   PSAMID:= copy(st, 58, 8);
   FlazzVersion:= copy(st, 160, 2);
   FlazzOtherData:= copy(st, 166, 20);

   Detail := Detail + RecordType + CardNo + ExpiryDate + Amount + SystemTraceNo + TransactionTime + TransactionDate + POSEntryMode + NII + POSConditionCode + TID + MID + InvoiceNo + UpdateStatus + ProductID + PurseExpiryDate + PursePAN + PurseBalance + PurseID + RTERM + CTC + CCARD30 +
                                            CTERM + TTC + CDC76 + TRN + YEAR + PSAMID + FlazzVersion + FlazzOtherData;
   end;

  FRecordType:= '0500';
  FTID:= terminalid;
  FMID:= MerchantID;

   while length(batchno) < 6 do
   batchno :=  '0' + batchno;

  FBatchNo:= batchno;
  FSalesCount:= IntToStr(report.Count);
   while length(FSalesCount) < 3 do
   FSalesCount :=  '0' + FSalesCount;

  Amt:= totalstr;
  FSalesAmount:= Amt + '00';
  FSettlementTime:= timesettle;
  FSettlementDate:= RightStr(datesettle, 4);
  FSettlementYear:= leftStr(datesettle, 4);
  FReserved:='';
   while length(FReserved) < 182 do
    FReserved:= FReserved + ' ';

  footer:= FRecordType + FTID + FMID + FBatchNo + FSalesCount + FSalesAmount + FSettlementTime + FSettlementDate + FSettlementYear + FReserved;

   write(tfOut, header + Detail + footer);

    CloseFile(tfOut);

    res := 0;
  except
    res := 1;
  end;

finally

end;

//end
//  else
//  begin
//     res := 3;
//  end;

result := res;

end;



exports
  Generate_Settlement_BNI,
  Generate_Settlement_MANDIRI,
  Generate_Settlement_BRI,
  Generate_Settlement_BCA;

begin
end.

