program autosettle_sti;

{$mode objfpc}{$H+}

uses
  {$IFDEF UNIX}{$IFDEF UseCThreads}
  cthreads,
  {$ENDIF}{$ENDIF}
  Classes, SysUtils, CustApp, pqconnection,
  sqldb,
  DB, config;
  { you can add units after this }

type

  { TMyApplication }

  TMyApplication = class(TCustomApplication)
   private
    config: Tconfig;
    Connection: TPQConnection;
    SQLTransaction: TSQLTransaction;
    SQLQuery: TSQLQuery;
    datasettle: TSQLQuery;
    SQLQuery4: TSQLQuery;
    SQLQuery5: TSQLQuery;
    SQLQuery1: TSQLQuery;
    SQLQuery2: TSQLQuery;
    SQLQuery3: TSQLQuery;
    filenya: TStringList;

    SQLQueryUpdate: TSQLQuery;
    Server_connected: boolean;
    function Db_connect(con: Tconfig): boolean;

  protected
    procedure DoRun; override;
 //   function Generate_Settlement_Single(Kode_Operator, Kode_Lokasi, DateTimeTrx, DateTimeSett, Sequence: string; TotalTrxMANDIRI, TotalAmountMANDIRI, TotalTrxBNI, TotalAmountBNI, TotalTrxBRI, TotalAmountBRI, TotalTrxBRIJava, TotalAmountBRIJava, TotalTrxBCA, TotalAmountBCA, TotalTrxDKI, TotalAmountDKI, TotalTrxMDD, TotalAmountMDD : int64; report: TStringList; ValidationMessage : string):Integer;

  private
    id_bank, nama_file : string;
    tidx, midx : string;
    batc,batc1 : integer;
    nominalnya : integer;
    indexnya   : integer;
    nom_tr     :string;
    posnya     : string;
    reportnya  : WideString;
    trx_mandiri, amt_mandiri,trx_bni,amt_bni,
    trx_bri, amt_bri, trx_bri_jav, amt_bri_jav,
    trx_dki, amt_dki, trx_mdd, amt_mdd, trx_bca,amt_bca: Integer;
         procedure load_data(tidnya: string;tglnya:TDate);
         procedure jalankan_single(tglnya:TDate);
         procedure jalankan_sti(tglnya:TDate ; posid : string);
         procedure load_settle(tglnya:TDate ; posid : string);
         procedure masuk_tr(tglnya:TDate ; posid : string);
         procedure masuk_dt(tglnya:TDate ; posid : string);
         procedure buat_notr;
         procedure extmidtidfromreport(rept : string; var mid, tid : string);
         function extractamount(rept: string): integer;
  public
    constructor Create(TheOwner: TComponent); override;
    destructor Destroy; override;
    procedure WriteHelp; virtual;
  end;

{ TMyApplication }

function TMyApplication.extractamount(rept: string):integer;
var amt : integer;
begin
   amt := StrToInt('$'+Copy(rept,57,8));
   Result := amt;
end;


procedure TMyApplication.extmidtidfromreport(rept : String; var mid,tid : string);
begin
     mid := Copy(rept,3,16);
     tid := Copy(rept,3 + 16, 8);
end;


procedure generate_total_single(report: TStringList; var amt: integer);
var
  i:integer;
  AmtStr: string;
  Data: string;

begin
if report.Count > 0 then
for i:=0 to pred(report.Count) do
begin
     Data:=report[i];
     AmtStr := copy(Data, 450, 8);
     amt := amt + StrToInt('$'+AmtStr);
  end;
end;

procedure generate_total_bank(report: TStringList; BankType: string; var amt, totalcount : integer);
var
  i:integer;
  AmtStr: string;
  Data: string;
  TypeData: string;

begin
if report.Count > 0 then
for i:=0 to pred(report.Count) do
begin
     Data:=report[i];
     TypeData:= copy(Data, 1, 1);
     if TypeData = BankType then
     Begin
     AmtStr := copy(Data, 450, 8);
     amt := amt + StrToInt('$'+AmtStr);
     totalcount:= totalcount+1;
     End
  end;
end;



function Generate_Settlement_Single(Kode_Operator, Kode_Lokasi, DateTimeTrx, DateTimeSett, Sequence: string; TotalTrxMANDIRI, TotalAmountMANDIRI, TotalTrxBNI, TotalAmountBNI, TotalTrxBRI, TotalAmountBRI, TotalTrxBRIJava, TotalAmountBRIJava, TotalTrxBCA, TotalAmountBCA, TotalTrxDKI, TotalAmountDKI, TotalTrxMDD, TotalAmountMDD : int64; report: TStringList; ValidationMessage : string):Integer;
var i: integer;
    filename: string;
    header: string;
    footer: string;
    st: string;
    tfOut: TextFile;

    totalstr: string;
    total: integer;
    res: integer;
    //report: TStringList;
    ThisMoment : TDateTime;

    icount: integer;
    count: integer;
    icountBank: integer;

    totalAmount: integer;

    countBankMandiri: integer;
    totalMandiri: integer;

    countBankBNI: integer;
    totalBNI: integer;

    countBankBRI: integer;
    totalBRI: integer;

    countBankBRIJava: integer;
    totalBRIJava: integer;

    countBankBCA: integer;
    totalBCA: integer;

    countBankDKI: integer;
    totalDKI: integer;

    countMDD: integer;
    totalMDD: integer;

    ValidationMessageStr: string;

    icountstr: string;
    countstr: string;
    totalAmountstr: string;
    icountBankstr: string;

    countBankMandiristr: string;
    totalMandiristr: string;

    countBankBNIstr: string;
    totalBNIstr: string;

    countBankBRIstr: string;
    totalBRIstr: string;

    countBankBRIJavastr: string;
    totalBRIJavastr: string;

    countBankBCAstr: string;
    totalBCAstr: string;

    countBankDKIstr: string;
    totalDKIstr: string;

    countMDDstr: string;
    totalMDDstr: string;
begin

res := 0;
//if read_file('\Reg.signature') then
begin

  ThisMoment:=Now;

  //report := TStringList.Create;
  //report.Delimiter := '|';
  //report.DelimitedText := reports;

try

//if TotalTrxMANDIRI = '' then
//TotalTrxMANDIRI := '0';
//
//if TotalAmountMANDIRI = '' then
//TotalAmountMANDIRI := '0';
//
//if TotalTrxBNI = '' then
//TotalTrxBNI := '0';
//
//if TotalAmountBNI = '' then
//TotalAmountBNI := '0';
//
//if TotalTrxBRI = '' then
//TotalTrxBRI := '0';
//
//if TotalAmountBRI = '' then
//TotalAmountBRI := '0';
//
//if TotalTrxBRIJava = '' then
//TotalTrxBRIJava := '0';
//
//if TotalAmountBRIJava = '' then
//TotalAmountBRIJava := '0';
//
//if TotalTrxBCA = '' then
//TotalTrxBCA := '0';
//
//if TotalAmountBCA = '' then
//TotalAmountBCA := '0';
//
//if TotalTrxDKI = '' then
//TotalTrxDKI := '0';
//
//if TotalAmountDKI = '' then
//TotalAmountDKI := '0';
//
//if TotalTrxMDD = '' then
//TotalTrxMDD := '0';
//
//if TotalAmountMDD = '' then
//TotalAmountMDD := '0';

If Not DirectoryExists('SettlementSingle\' + FormatDateTime('DDMMYYYY',ThisMoment)) then
   ForceDirectories('SettlementSingle\' + FormatDateTime('DDMMYYYY',ThisMoment));

 filename := Kode_Operator + Kode_Lokasi + DateTimeTrx + DateTimeSett + '0000' + '_' + Sequence;

 AssignFile(tfOut,'SettlementSingle\' + FormatDateTime('DDMMYYYY',ThisMoment) + '\' + filename + '.txt');

 try
  rewrite(tfOut);

  count:= report.Count;
  icount:=0;
  icount := icount + 1;

  totalAmount:= 0;
  generate_total_single(report, totalAmount);

  icountBank:= 0;

  //MANDIRI
  countBankMandiri:= 0;
  totalMandiri:=0;
  generate_total_bank(report, '0', totalMandiri, countBankMandiri);
  if (TotalTrxMANDIRI <> countBankMandiri) then
    begin
    ValidationMessageStr:= 'Total Trx MANDIRI tidak sesuai, Report Data =' + IntTostr(countBankMandiri);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else if (totalMandiri <> TotalAmountMANDIRI) then
    begin
    ValidationMessageStr:= 'Total Amount MANDIRI tidak sesuai, Report Data =' + IntTostr(totalMandiri);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else
  begin
       If (countBankMandiri > 0) Then
       begin
          icount := icount + 1;
          icountBank := icountBank + 1;
       end
  end;
  //


 //BNI
  countBankBNI:= 0;
  totalBNI:= 0;
  generate_total_bank(report, '3', totalBNI, countBankBNI);
  if (TotalTrxBNI <> countBankBNI) then
    begin
    ValidationMessageStr:= 'Total Trx BNI tidak sesuai, Report Data =' + IntTostr(countBankBNI);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else if (totalBNI <> TotalAmountBNI) then
    begin
    ValidationMessageStr:= 'Total Amount BNI tidak sesuai, Report Data =' + IntTostr(totalBNI);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else
  begin
       If (countBankBNI > 0) Then
       begin
          icount := icount + 1;
          icountBank := icountBank + 1;
       end
  end;
  //

  //BRI
  countBankBRI:= 0;
  totalBRI:= 0;
  generate_total_bank(report, '2', totalBRI, countBankBRI);
  if (TotalTrxBRI <> countBankBRI) then
    begin
    ValidationMessageStr:= 'Total Trx BRI tidak sesuai, Report Data =' + IntTostr(countBankBRI);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else if (totalBRI <> TotalAmountBRI) then
    begin
    ValidationMessageStr:= 'Total Amount BRI tidak sesuai, Report Data =' + IntTostr(totalBRI);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else
  begin
       If (countBankBRI > 0) Then
       begin
          icount := icount + 1;
          icountBank := icountBank + 1;
       end
  end;
  //

  //BRI JAVA
  countBankBRIJava:= 0;
  totalBRIJava:= 0;
  generate_total_bank(report, '1', totalBRIJava, countBankBRIJava);
  if (TotalTrxBRIJava <> countBankBRIJava) then
    begin
    ValidationMessageStr:= 'Total Trx BRI Java tidak sesuai, Report Data =' + IntTostr(countBankBRIJava);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else if (totalBRIJava <> TotalAmountBRIJava) then
    begin
    ValidationMessageStr:= 'Total Amount BRI Java tidak sesuai, Report Data =' + IntTostr(totalBRIJava);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else
  begin
       If (countBankBRIJava > 0) Then
       begin
          icount := icount + 1;
          icountBank := icountBank + 1;
       end
  end;
  //

  //BCA
  countBankBCA:= 0;
  totalBCA:= 0;
  generate_total_bank(report, '5', totalBCA, countBankBCA);
  if (TotalTrxBCA <> countBankBCA) then
    begin
    ValidationMessageStr:= 'Total Trx BCA tidak sesuai, Report Data =' + IntTostr(countBankBCA);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else if (totalBCA <> TotalAmountBCA) then
    begin
    ValidationMessageStr:= 'Total Amount BCA tidak sesuai, Report Data =' + IntTostr(totalBCA);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else
  begin
       If (countBankBCA > 0) Then
       begin
          icount := icount + 1;
          icountBank := icountBank + 1;
       end
  end;
  //

  //DKI
  countBankDKI:= 0;
  totalDKI:= 0;
  generate_total_bank(report, '4', totalDKI, countBankDKI);
  if (TotalTrxDKI <> countBankDKI) then
    begin
    ValidationMessageStr:= 'Total Trx DKI tidak sesuai, Report Data =' + IntTostr(countBankDKI);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else if (totalDKI <> TotalAmountDKI) then
    begin
    ValidationMessageStr:= 'Total Amount DKI tidak sesuai, Report Data =' + IntTostr(totalDKI);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else
  begin
       If (countBankDKI > 0) Then
       begin
          icount := icount + 1;
          icountBank := icountBank + 1;
       end
  end;
  //

  //MDD
  countMDD:= 0;
  totalMDD:= 0;
  generate_total_bank(report, 'c', totalMDD, countMDD);
  if (TotalTrxMDD <> countMDD) then
    begin
    ValidationMessageStr:= 'Total Trx MDD tidak sesuai, Report Data =' + IntTostr(countMDD);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else if (totalMDD <> TotalAmountMDD) then
    begin
    ValidationMessageStr:= 'Total Amount MDD tidak sesuai, Report Data =' + IntTostr(totalMDD);
    ValidationMessage := ValidationMessageStr;
    result := 2;
    end
  else
  begin
       If (countMDD > 0) Then
       begin
          icount := icount + 1;
          icountBank := icountBank + 1;
       end
  end;
  //

  countstr:=IntToStr(count);
  while length(countstr) < 6 do
  countstr :=  '0' + countstr;

  totalAmountstr:=IntToStr(totalAmount);
  while length(totalAmountstr) < 9 do
  totalAmountstr :=  '0' + totalAmountstr;

  write(tfOut, countstr + totalAmountstr + #10);

  if (countBankMandiri > 0) then
  begin
     countBankMandiristr:=IntToStr(countBankMandiri);
     while length(countBankMandiristr) < 6 do
     countBankMandiristr :=  '0' + countBankMandiristr;

     totalMandiristr:=IntToStr(totalMandiri);
     while length(totalMandiristr) < 9 do
     totalMandiristr :=  '0' + totalMandiristr;

     write(tfOut, '01' + countBankMandiristr + totalMandiristr + #10)
  end;

  if (countBankBNI > 0) then
  begin
     countBankBNIstr:=IntToStr(countBankBNI);
     while length(countBankBNIstr) < 6 do
     countBankBNIstr :=  '0' + countBankBNIstr;

     totalBNIstr:=IntToStr(totalBNI);
     while length(totalBNIstr) < 9 do
     totalBNIstr :=  '0' + totalBNIstr;

     write(tfOut, '02' + countBankBNIstr + totalBNIstr + #10)
  end;

  if (countBankBRI > 0) then
  begin
     countBankBRIstr:=IntToStr(countBankBRI);
     while length(countBankBRIstr) < 6 do
     countBankBRIstr :=  '0' + countBankBRIstr;

     totalBRIstr:=IntToStr(totalBRI);
     while length(totalBRIstr) < 9 do
     totalBRIstr :=  '0' + totalBRIstr;

     write(tfOut, '03' + countBankBRIstr + totalBRIstr + #10)
  end;

  if (countBankBRIJava > 0) then
  begin
     countBankBRIJavastr:=IntToStr(countBankBRIJava);
     while length(countBankBRIJavastr) < 6 do
     countBankBRIJavastr :=  '0' + countBankBRIJavastr;

     totalBRIJavastr:=IntToStr(totalBRIJava);
     while length(totalBRIJavastr) < 9 do
     totalBRIJavastr :=  '0' + totalBRIJavastr;

     write(tfOut, '04' + countBankBRIJavastr + totalBRIJavastr + #10)
  end;

  if (countBankBCA > 0) then
  begin
     countBankBCAstr:=IntToStr(countBankBCA);
     while length(countBankBCAstr) < 6 do
     countBankBCAstr :=  '0' + countBankBCAstr;

     totalBCAstr:=IntToStr(totalBCA);
     while length(totalBCAstr) < 9 do
     totalBCAstr :=  '0' + totalBCAstr;

     write(tfOut, '05' + countBankBCAstr + totalBCAstr + #10)
  end;

  if (countBankDKI > 0) then
  begin
     countBankDKIstr:=IntToStr(countBankDKI);
     while length(countBankDKIstr) < 6 do
     countBankDKIstr :=  '0' + countBankDKIstr;

     totalDKIstr:=IntToStr(totalDKI);
     while length(totalDKIstr) < 9 do
     totalDKIstr :=  '0' + totalDKIstr;

     write(tfOut, '06' + countBankDKIstr + totalDKIstr + #10)
  end;

  if (countMDD > 0) then
  begin
     countMDDstr:=IntToStr(countMDD);
     while length(countMDDstr) < 6 do
     countMDDstr :=  '0' + countMDDstr;

     totalMDDstr:=IntToStr(totalMDD);
     while length(totalMDDstr) < 9 do
     totalMDDstr :=  '0' + totalMDDstr;

     write(tfOut, '07' + countMDDstr + totalMDDstr + #10)
  end;

  if report.Count > 0 then
  for i:=0 to pred(report.Count) do
   begin
   icount:= icount + 1;
   st:='';
   st:= (report[i]);
   st:= Copy(st,2,448);
      write(tfOut, st + #10);
   end;

  icount:= icount + 1;

  icountBankstr:= IntToStr(icountBank);
  while length(icountBankstr) < 2 do
  icountBankstr :=  '0' + icountBankstr;

  icountstr:= IntToStr(icount);
  while length(icountstr) < 4 do
  icountstr :=  '0' + icountstr;

  footer:= Kode_Operator + icountBankstr + icountstr;
  write(tfOut, footer);

  CloseFile(tfOut);

  res := 0;
  except
    res := 1;
  end;

finally
    //report.Free;
end;

end ;
{  else
  begin
     res := 3;
  end; }

result := res;

end;

procedure TMyApplication.jalankan_sti(tglnya:TDate ; posid : string);
var
  Filename : string;
  mid, tid : string;
  header   : string;
  totamt   : integer;
  tottrx   : integer;
  stramt   : string;
  strtrx,ss: string;
  i, l     : integer;
  ts       : TStringList;
  readermid: string;
  readertid: string;
  lastmid  : string;
  lasttid  : string;
  report   : string;
  strconten: TStringList;
  isinya   : TStringList;
begin
//     tottrx:= StrToInt(Edit3.Text);
     tottrx:=SQLQuery4.FieldByName('jml').AsInteger;
     SQLQuery2.First;
       report:=SQLQuery2.FieldByName('rep_content').AsString;
        strconten     := TStringList.Create;
       extmidtidfromreport(report,readermid,readertid);
       lastmid:=readermid;
       lasttid:=readertid;
       l      := 0;
       if Length(IntToStr(indexnya))=1 then
       begin
          ss:='0'+IntToStr(indexnya);
       end
       else
       begin
            ss:=inttostr(indexnya);
       end;
       for l := 1 to SQLQuery2.RecordCount do
       begin

           // while (lastmid = readermid) do
            begin
                 report    := SQLQuery2.FieldByName('rep_content').AsString;
                 if (Length(report)>0) then
                 begin
                      extmidtidfromreport(report,readermid,readertid);
                      strconten.Add(report);
                 end
                 else
                 begin
                      readermid:='';
                      readertid:='';
                 end;
            end;
            SQLQuery2.Next;
       end;
       totamt:=0;
       for i := 0 to strconten.Count-1 do
          totamt:=totamt+extractamount(strconten[i]);

       mid:= lastmid;
       while Length(mid)<16 do
             mid := '0' + mid;
       tid:=lasttid;
       while Length(tid)<8 do
             tid:='0'+tid;

   //    Filename:= FormatDateTime('YYYYMMDDhhnnss',tglnya)+mid+tid+'01'+IntToHex(1,3)+'.txt';
       Filename:= FormatDateTime('YYYYMMDD',tglnya)+FormatDateTime('hhnn',now())+ss+mid+tid+'01'+IntToHex(1,3)+'.txt';
       strtrx:= IntToStr(strconten.Count);
       while Length(strtrx) < 3 do
             strtrx:='0' + strtrx;
       stramt:=IntToStr(totamt);
       while Length(stramt)<10 do
             stramt:='0'+stramt;
       header:=strtrx+stramt;
       ts    := TStringList.Create;
       ts.Add(header);
       for i := 0 to strconten.Count -1 do
           ts.Add(strconten[i]);
       ts.SaveToFile('.\bank_report\'+Filename);
       ts.Free;
       load_settle(tglnya,posid);
      { SQLQuery1.Active:=false;
       SQLQuery1.SQL.Clear;
       for i := 0 to strconten.Count-1 do
           SQLQuery1.SQL.Add('update transaksi_parkir set rep_has_settle = 1 where );}
end;


procedure TMyApplication.load_settle(tglnya:TDate ; posid : string);
var
  sq      : string;
  tid     : string;
  nom,i     : Integer;
begin
     sq := '';
     //if id_bank='30' then
     begin;
     sq := 'update transaksi_parkir set rep_has_settle = 1 '+
           ' where rep_has_settle = 0 '+
           ' and length(rep_content) > 5 '+
           ' and id_pintu_keluar = :bank'+
           ' and waktu_keluar between '+quotedstr(FormatDateTime('mm/dd/yyyy', tglnya))+' and '+quotedstr(FormatDateTime('mm/dd/yyyy', tglnya+1)) +
           '; ';
     {sq := 'update transaksi_parkir set rep_has_settle = 1 , refference_id_settlement = '+quotedstr(nom_tr)+
           ' where rep_has_settle = 0 '+
           ' and rep_content is not null'+
        //   ' and rep_bank = :bank'+
           ' and id_pintu_keluar in (select id_pos  from config_pos_hardware where bank_reader_tid = '+quotedstr(tidx)+
           ' ) and waktu_keluar between '+quotedstr(FormatDateTime('mm/dd/yyyy', DateTimePicker2.Date))+' and '+quotedstr(FormatDateTime('mm/dd/yyyy', DateTimePicker2.Date+1)) +
           '; ';  }

     end;
     //else
    { if id_bank='35' then
     begin
     sq := 'update transaksi_parkir set rep_has_settle = 1 '+
           ' where rep_has_settle = 0 '+
           ' and rep_content is not null'+
           ' and rep_bank = :bank'+
           ' and id_pintu_keluar in (select id_pos  from config_pos_hardware where bca_reader_tid = '+quotedstr(tidx)+
           ' ) and waktu_keluar between '+quotedstr(FormatDateTime('mm/dd/yyyy', DateTimePicker2.Date))+' and '+quotedstr(FormatDateTime('mm/dd/yyyy', DateTimePicker2.Date+1)) +
           ';  ';
     sq:= sq + 'update config_pos_hardware set bca_batch = '+inttostr(batc+1)+'  where bca_reader_tid = '+quotedstr(tidx)+';';
     end;

     batc:=batc+1;}
     datasettle.Active:=false;
     datasettle.SQL.Clear;
     datasettle.SQL.Add(sq);
     datasettle.ParamByName('bank').AsString:=posid;
     datasettle.ExecSQL;
     SQLTransaction.CommitRetaining;
end;


procedure TMyApplication.buat_notr;
var
  st : string;
begin
     st := 'select to_char(now(),''yymmddhhmmss'')as no';
     SQLQuery3.Active:=false;
     SQLQuery3.SQL.Clear;
     SQLQuery3.SQL.Add(st);
     SQLQuery3.Active:=true;

     nom_tr:=SQLQuery3.FieldByName('no').AsString;
end;

procedure TMyApplication.masuk_tr(tglnya:TDate ; posid : string);
var
  st : string;
begin
     SQLQuery3.Clear;
     st := 'insert into settlement_tr (notrans, nama_file, "TID", tgl_pembuatan,tgl_transaksi, status_buat_settlement,created_by, '+
     ' amt_mandiri, amt_mdd, amt_dki, amt_bca, amt_bri_java, amt_bri, amt_bni,trx_mandiri, trx_mdd, trx_dki, trx_bca, trx_bri_java, trx_bri, trx_bni )'+
        'values ('+QuotedStr(nom_tr)+','+quotedstr(nama_file)+','+tidx+',now(),'+quotedstr(FormatDateTime('yyyy-mm-dd',tglnya))+',1,'+QuotedStr('administrator')+
        ', '+inttostr(amt_mandiri)+','+inttostr(amt_mdd)+','+inttostr(amt_dki)+','+inttostr(amt_bca)+','+inttostr(amt_bri_jav)+','+inttostr(amt_bri)+','+inttostr(amt_bni)+','+inttostr(trx_mandiri)+','+inttostr(trx_mdd)+','+inttostr(trx_dki)+','+inttostr(trx_bca)+','+inttostr(trx_bri_jav)+','+inttostr(trx_bri)+','+inttostr(trx_bni)+');';
     //SQLQuery3.Active:=false;
     SQLQuery3.SQL.Clear;
     SQLQuery3.SQL.Add(st);
     SQLQuery3.ExecSQL;
     SQLTransaction.CommitRetaining;

end;


procedure TMyApplication.masuk_dt(tglnya:TDate ; posid : string);
var
  st : string;
begin
     SQLQuery3.Clear;
     st := 'insert into settlement_dt (no_trans, rep_content, nominal) '+
        'values('+QuotedStr(nom_tr)+','+QuotedStr(reportnya)+','+inttostr(nominalnya)+');';
   //  SQLQuery3.Active := false;
     SQLQuery3.SQL.Clear;
     SQLQuery3.SQL.Add(st);
     SQLQuery3.ExecSQL;
     SQLTransaction.CommitRetaining;
end;


procedure TMyApplication.load_data(tidnya: string;tglnya:tDate);
var
  sq      : string;
  tid     : string;
  nom,i     : Integer;
begin
     sq := '';
     tidx:=Trim(tidnya);
     sq := 'select bayar_keluar, id_pintu_keluar, nama_pos.nama, rep_bank, rep_content, waktu_keluar as keluar '+
           'from transaksi_parkir, nama_pos, config_pos_hardware a '+
           ' where rep_has_settle = 0 '+
           ' and length(rep_content)>5 '+
           ' and rep_bank <> ''9'' '+
           ' and nama_pos.id= a.id_pos '+
       //    ' and a.bank_reader_tid = '+quotedstr(tidx)+
           ' and a.id_pos = '+ quotedstr(tidx)+
           ' and waktu_keluar between '+quotedstr(FormatDateTime('mm/dd/yyyy', tglnya))+' and '+quotedstr(FormatDateTime('mm/dd/yyyy', tglnya+1)) +
           ' and id_pintu_keluar = nama_pos.id and waktu_keluar is not null ';


     SQLQuery2.Active:=false;
     SQLQuery2.SQL.Clear;
     SQLQuery2.SQL.Add(sq);
     SQLQuery2.Active:=false;
     SQLQuery2.Active:=true;

   //  batc:= SQLQuery2.FieldByName('bca_batch').AsInteger;

     nom:=0;
     trx_mandiri:=0;
     amt_mandiri:=0;
     trx_mdd:=0;
     amt_mdd:=0;
     trx_dki:=0;
     amt_dki:=0;
     trx_bri_jav:=0;
     amt_bri_jav:=0;
     trx_bri:=0;
     amt_bri:=0;
     trx_bni:=0;
     amt_bni:=0;
     trx_bca:=0;
     amt_bca:=0;

    { for i :=0 to SQLQuery2.RecordCount-1 do
     begin
          if SQLQuery2.FieldByName('rep_bank').AsString='c' then
          begin
               amt_mdd:=amt_mdd+SQLQuery2.FieldByName('bayar_keluar').AsInteger;
               trx_mdd:=trx_mdd+1;
          end;
          if SQLQuery2.FieldByName('rep_bank').AsString='1' then
          begin
               amt_bri_jav:=amt_bri_jav+SQLQuery2.FieldByName('bayar_keluar').AsInteger;
               trx_bri_jav:=trx_bri_jav+1;
          end;
          if SQLQuery2.FieldByName('rep_bank').AsString='0' then
          begin
               amt_mandiri:=amt_mandiri+SQLQuery2.FieldByName('bayar_keluar').AsInteger;
               trx_mandiri:=trx_mandiri+1;
          end;
          if SQLQuery2.FieldByName('rep_bank').AsString='2' then
          begin
               amt_bri:=amt_bri+SQLQuery2.FieldByName('bayar_keluar').AsInteger;
               trx_bri:=trx_bri+1;
          end;
          if SQLQuery2.FieldByName('rep_bank').AsString='3' then
          begin
               amt_bni:=amt_bni+SQLQuery2.FieldByName('bayar_keluar').AsInteger;
               trx_bni:=trx_bni+1;
          end;
          if SQLQuery2.FieldByName('rep_bank').AsString='4' then
          begin
               amt_dki:=amt_dki+SQLQuery2.FieldByName('bayar_keluar').AsInteger;
               trx_dki:=trx_dki+1;
          end;
          if SQLQuery2.FieldByName('rep_bank').AsString='5' then
          begin
               amt_bca:=amt_bca+SQLQuery2.FieldByName('bayar_keluar').AsInteger;
               trx_bca:=trx_bca+1;
          end;

          SQLQuery2.Next;
     end;}
     //nom := dataview.FieldByName('nominal').AsInteger;
     tid:=tidx;
    { Edit1.Text:=FormatDateTime('MM/dd/yyyy', DateTimePicker2.Date);
     Edit2.Text:='';
     edit3.Text:=inttostr(SQLQuery2.RecordCount);}
  //   edit4.Text:=inttostr(nom);

end;

procedure TMyApplication.jalankan_single(tglnya:TDate);
var
  sq,st             : string;
  i, res            : integer;
  StrMandiri        : TStringList;
  rep_content       : widestring;
  terminalidx       : string;
  institution       : string;
  shiftid, bat      : string;
  filename          : string;
  datetrx, dateset,timeset  : string;
  v  : Integer;
    er : Integer;
    report : string;
    StrBNI: TStringList;
    StrBRI: TStringList;
    StrBCA: TStringList;
    StrSingle: TStringList;
    ValidationMsg: string;
begin



     StrSingle:= TStringList.Create;
     buat_notr;
    // load_config;
     st := 'select to_char(now(),''ddMMyyhhmiss'') as jam;';
     SQLQuery1.Active:=false;
     SQLQuery1.SQL.Clear;
     SQLQuery1.SQL.Add(st);
     SQLQuery1.Active:=false;
     SQLQuery1.Active:=True;
     datetrx       := formatdatetime('ddMMyyhhmmss',SQLQuery2.FieldByName('keluar').AsDateTime);
     dateset       := SQLQuery1.FieldByName('jam').AsString;
     tglnya:=now();
     filename:='';
     filename:=Copy(tidx,1,4)+Copy(tidx,1,6)+datetrx+dateset+'0000'+'_'+'01';
     nama_file:=filename;
    // ShowMessage(inttostr());


    SQLQuery2.First;
     for i := 1 to SQLQuery2.RecordCount do
     begin
        //  load_config;
        reportnya := SQLQuery2.FieldByName('rep_content').AsWideString;
        nominalnya:= SQLQuery2.FieldByName('bayar_keluar').AsInteger;
            masuk_dt(tglnya,posnya);
        //  rep_content   := copy(SQLQuery2.FieldByName('rep_content').AsWideString,2,Length(SQLQuery2.FieldByName('rep_content').AsWideString));
          rep_content   := SQLQuery2.FieldByName('rep_content').AsWideString;
          terminalidx   := tidx;
          institution   := midx;

          begin
               try
                  StrSingle.Add(rep_content);
//                  StrMandiri.Add(rep_content);
//                  StrMandiri.Add('603298400000020200020D706E81641A1C0123456701200A000000DBC00B00160517215543220B00008F03034CB741');

                   SQLQuery2.Next;
               finally
//
          end;

     end;
     end;
         ValidationMsg:='';
         res:=Generate_Settlement_Single(Copy(tidx,1,4),Copy(tidx,1,6),datetrx,dateset,'01',trx_mandiri, amt_mandiri, trx_bni,amt_bni,trx_bri,amt_bri, trx_bri_jav,amt_bri_jav,trx_bca,amt_bca, trx_dki,amt_dki,trx_mdd, amt_mdd,StrSingle,ValidationMsg);
//         res:= Generate_Settlement_MANDIRI( institution,'0001', terminalidx,datetrx,dateset, StrMandiri);
//                  res:= Generate_Settlement_MANDIRI( '0003', '0002', '01234567','221020182048','221020182048', StrMandiri);
                  if res = 0 then
                  begin
                       load_settle(tglnya,posnya);
                       masuk_tr(tglnya,posnya);
                      // Memo1.Lines.SaveToFile('SettlementSingle\' + FormatDateTime('DDMMYYYY',Date) + '\' + filename + '.ok');
                       //load_settle;
                   //    ShowMessage('Settlement Single' + sLineBreak + 'Berhasil !' );

                  end;

             StrSingle.Free;
    end;


procedure TMyApplication.DoRun;
var
    sq : string;
    i : integer;
    ErrorMsg: String;
begin
  // quick check parameters
  ErrorMsg:=CheckOptions('h', 'help');
  if ErrorMsg<>'' then begin
    ShowException(Exception.Create(ErrorMsg));
    Terminate;
    Exit;
  end;

  // parse parameters
  if HasOption('h', 'help') then begin
    WriteHelp;
    Terminate;
    Exit;
  end;

  { add your program here }

   config:=Tconfig.Create('./myconfig.ini');
  Db_connect(config);
  SQLQuery.PacketRecords:=-1;
  SQLQuery1.PacketRecords:=-1;
  SQLQuery2.PacketRecords:=-1;
  SQLQuery3.PacketRecords:=-1;
  SQLQuery4.PacketRecords:=-1;
  SQLQuery5.PacketRecords:=-1;
  datasettle.PacketRecords:=-1;
  SQLQuery.DataBase:=Connection;
  SQLQuery5.DataBase:=Connection;
  SQLQuery4.DataBase:=Connection;
  SQLQuery3.DataBase:=Connection;
  SQLQuery2.DataBase:=Connection;
  SQLQuery1.DataBase:=Connection;
  datasettle.DataBase:=Connection;

     SQ := '';
     SQ := 'UPDATE TRANSAKSI_PARKIR SET REP_HAS_SETTLE =0 WHERE REP_HAS_SETTLE IS NULL AND CARA_BAYAR =3';
     SQLQuery5.Clear;
     SQLQuery5.SQL.Clear;
     SQLQuery5.SQL.Add(SQ);
     SQLQuery5.ExecSQL;
     SQLTransaction.CommitRetaining;


     sq :='';

     sq :='select date(waktu_keluar) as tgl,sum(bayar_keluar) as nom,count(no_pol)as jml, b.id_pos as bank_reader_tid '+
                  'from transaksi_parkir a, config_pos_hardware b '+
                  ' where cara_bayar=3 '+
                  ' and rep_bank <> ''9'' '+
                  ' and a.rep_has_settle =0 '+
                  ' and bayar_keluar > 0 '+
                  ' and date(waktu_keluar) <> date(now()) '+
                  ' and id_pintu_keluar = b.id_pos '+
                  ' group by date(waktu_keluar), id_pos '+
                  ' order by date(waktu_keluar);';
     SQLQuery4.SQL.Clear;
     SQLQuery4.Active:=false;
     SQLQuery4.SQL.Add(sq);
     SQLQuery4.Active:=true;

     SQLQuery4.First;
     //for i := 0 to SQLQuery4.RecordCount-1 do
     while not SQLQuery4.EOF do
     begin
          posnya:=SQLQuery4.FieldByName('bank_reader_tid').AsString;
        //  Memo3.Lines.Add('POS '+SQLQuery4.FieldByName('bank_reader_tid').AsString);
        //  Memo3.Lines.Add('tanggal '+SQLQuery4.FieldByName('tgl').AsString);


          //tidnya:=SQLQuery4.FieldByName('bank_reader_tid').AsString;
          //load_data(SQLQuery4.FieldByName('bank_reader_tid').AsString,SQLQuery4.FieldByName('tgl').AsDateTime);
          load_data(SQLQuery4.FieldByName('bank_reader_tid').AsString,SQLQuery4.FieldByName('tgl').AsDateTime);
         // jalankan_single(SQLQuery4.FieldByName('tgl').AsDateTime);
         jalankan_sti(SQLQuery4.FieldByName('tgl').AsDateTime,posnya);
         indexnya:=indexnya+1;
          //ProgressBar1.Position:=ProgressBar1.Position+1;
         // Memo3.Lines.Add('total '+SQLQuery4.FieldByName('nom').AsString);
        //  Memo3.Lines.Add('jumlah '+SQLQuery4.FieldByName('jml').AsString);
        //  Memo3.Lines.Add('=========================');
        //  Memo3.Lines.Add('');
      //    ShowMessage('settlement sudah selesai POS'+quotedstr(posnya));
          SQLQuery4.Next;
     end;
  // stop program loop
  Terminate;
end;

function TMyApplication.Db_connect(con: Tconfig): boolean;
  begin
    Server_connected := false;
    Connection.HostName := con.host;
    Connection.UserName := con.user;
    Connection.Password := con.password;
    Connection.DatabaseName := con.database;

    try
      Connection.Connected := False;
    except
    end;

    try
      Connection.Connected := True;
      Server_connected := True;
    except
    end;

    Result := Server_connected;
  end;

constructor TMyApplication.Create(TheOwner: TComponent);
begin
  inherited Create(TheOwner);
  StopOnException:=True;

   inherited Create(TheOwner);
   StopOnException := True;

   Connection := TPQConnection.Create(nil);
   SQLTransaction := TSQLTransaction.Create(nil);
   SQLQuery := TSQLQuery.Create(nil);
   SQLQuery1 := TSQLQuery.Create(nil);
   SQLQuery2 := TSQLQuery.Create(nil);
   SQLQuery3 := TSQLQuery.Create(nil);
   SQLQuery4 := TSQLQuery.Create(nil);
   SQLQuery5 := TSQLQuery.Create(nil);
   datasettle:= TSQLQuery.Create(nil);
   SQLQueryUpdate := TSQLQuery.Create(nil);

   Connection.Transaction := SQLTransaction;
   SQLTransaction.DataBase := Connection;
   SQLQuery.DataBase := Connection;
   SQLQueryUpdate.DataBase := Connection;
end;

destructor TMyApplication.Destroy;
begin
  inherited Destroy;
end;

procedure TMyApplication.WriteHelp;
begin
  { add your help code here }
  writeln('Usage: ', ExeName, ' -h');
end;

var
  Application: TMyApplication;
begin
  Application:=TMyApplication.Create(nil);
  Application.Title:='SETTLEMENT STI';
  Application.Run;
  Application.Free;
end.

