unit config;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, IniFiles;

type
  Pconfig = ^Tconfig;

  Tconfig = class(TObject)
  private
    pghost: string;
    pgport: string;
    pguser: string;
    pgpwd: string;
    pgdb: string;

  public
    constructor Create(filename: string);

    property host: string read pghost;
    property port: string read pgport;
    property user: string read pguser;
    property password: string read pgpwd;
    property database: string read pgdb;
  end;

implementation
constructor Tconfig.Create(filename: string);
var
  ini: TIniFile;
begin
  inherited Create;
  ini := TIniFile.Create(filename);


  pghost := ini.ReadString('CONNECTION', 'HOST', '192.168.200.10');
  pgport := ini.ReadString('CONNECTION', 'PORT', '5432');
  pguser := ini.ReadString('CONNECTION', 'USER', 'postgres');
  pgpwd := ini.ReadString('CONNECTION', 'PWD', '521478');
  pgdb := ini.ReadString('CONNECTION', 'DB', 'kemayoran');
end;

end.

